//---------------------------------------------------------------------------
#ifndef Unit2H
#define Unit2H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <SysUtils.hpp>
#include <stdio.h>
#include "binary.h"
#include "mp3_info.h"
#include "fcd.h"
#include "filename.h"
#include "mode.h"
#include "cue.h"
#include "ccd.h"
#include "cdi.h"
#include "nrg.h"
#include "language.h"
#include "Unit1.h"
#include "Unit4.h"
//---------------------------------------------------------------------------
class TForm2 : public TForm
{
__published:	// IDE Ǘ̃R|[lg
    TProgressBar *PB;
    TLabel *Label1;
    TLabel *Label2;
    TLabel *block_view;
    TLabel *track_view;
    TLabel *Label3;
    TLabel *filename_view;
    TButton *Button1;
    void __fastcall Button1Click(TObject *Sender);
    void __fastcall FormCloseQuery(TObject *Sender, bool &CanClose);
    void __fastcall FormCreate(TObject *Sender);
private:	// [U[錾
    bool interrupt;
    bool working;
    int language;
    AnsiString error_msg;
    LBN __fastcall convert_to_iso(FCD *in, FILE *out);
    LBN __fastcall convert_to_fcd(FCD *fcd);
    char * __fastcall concoct_track_name(FCD *fcd, int track);
    void __fastcall copy_mp3(FCD *fcd, int index);
    void __fastcall wrap_mp3(char *mp3_file, char *wav_file);
    void __fastcall copy_wav(FCD *fcd, int index);
    void __fastcall WMSysCommand(TWMSysCommand& Msg);
    void __fastcall set_filename_view(char *filename);
    void __fastcall DAO_INFO_to_FCD(DAO_INFO *in, FCD *out);
    LBN __fastcall bin2fcd(dao_track *bin, FCD *out);
    LBN __fastcall bin2wav(dao_track *bin, char *outfile);
    void __fastcall set_language();    
    void __fastcall file_open_error(char *filename);
    void __fastcall file_create_error(char *filename);
    void __fastcall temporal_create_error(char *temporal);
    void __fastcall file_write_error(char *filename);
    void __fastcall mp3_open_error(char *mp3_file);
    void __fastcall cue_open_error(char *cue_file);
    void __fastcall fcd_open_error(char *fcd_file);
    void __fastcall ccd_open_error(char *ccd_file);
    void __fastcall cdi_open_error(char *cdi_file);
    void __fastcall nrg_open_error(char *nrg_file);
    void __fastcall fcd_has_no_data_track(char *fcd_file);
    void __fastcall unknown_mode_track_error(char *fcd_file, int track);
    void __fastcall audio_mode_track_error(char *fcd_file, int track);
    void __fastcall unknown_compression_error(char *fcd_file, int track);
    void __fastcall move_next_track_error(char *fcd_file, int track);
    void __fastcall add_track_data_error(char *iso_file);
    void __fastcall add_track_wav_error(char *wav_file);
    void __fastcall add_track_mp3_error(char *mp3_file);
    void __fastcall file_rename_error(int error_number, char *before, char *after);
    void __fastcall cant_overwrite_conversion_multiple_image();
    void __fastcall cant_overwrite_conversion_audio_cd();
    void __fastcall cant_overwrite_conversion_cd_extra();
    void __fastcall cant_overwrite_conversion_2336_image();
    void __fastcall cant_overwrite_conversion_different_drive();
    int __fastcall query_overwrite(char *path);
    int __fastcall query_interrupt();
    int __fastcall raw_mode_track_warning(char *fcd_file, int track, int block_size);
    BEGIN_MESSAGE_MAP
        VCL_MESSAGE_HANDLER(WM_SYSCOMMAND, TWMSysCommand, WMSysCommand)
    END_MESSAGE_MAP(TForm)
public:		// [U[錾
    int mode;
    __fastcall TForm2(TComponent* Owner);
    void __fastcall fcd2iso(char *fcd_file);
    void __fastcall fcd2fcd(char *fcd_file);
    void __fastcall iso2fcd(char *iso_file);
    void __fastcall dao2fcd(char *cue_file);
    void __fastcall wrap_only(char *mp3_file);
};
//---------------------------------------------------------------------------
extern PACKAGE TForm2 *Form2;
//---------------------------------------------------------------------------
#endif
